--  
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
GameObject = {
    Params = {
        ID="cheesemachine";
        width=2;
        height=4;
        --health=3200;
        timerTask=-1;       -- do not change this parameter ( )
        --RandomTasks=0;
        GridData= { 
            1, 1,
            1, 1
        };
        group=6; --                
        create_product = 10;  --   ()
        product_name = "cheese"; -- do not change this parameter
        PassToChildMD = 1;
    };
    ActivePoints = { 
        switch_on = { 
                   { {}, -1,0,0,  0,  0,0,0 };
                   }; 
        take   = { 
                   { {"cheese"}, 0,2,0, 0,  0,0,0 };
                 }; 
    };
    Objects = {
        cheese = { };
    };
    -- list of all tasks for an object
    Tasks = {
        switch_on = { FuncName="SwitchOnTaskExecute", sleeping={0}, timer=1, time_tick=100 };
    };
    -- list of all triggers for an object
    Triggers = {
        SwitchOn = {FuncName="SwitchOnTrigger", NotRunWhen={"switch_on"}, work_time=6, time_tick=300, cur_value=-1 }
    };
    --tasks to be performed after an object is created
    InitActiveTasks = {};
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {"switch_on"};
    
    curObj = 0; --  ,  
    curPortion = 0;--  ,    
};
function GameObject:Get()
    return self;
end


--        
function OnInit()
    aObj = GameObject:Get();   
    if( not aObj.Params.MaxHealth )then
        aObj.Params.MaxHealth = aObj.Params.health;
    end;
end
    

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

-- perform Task switch_on over external object and return true if task is completed
function SwitchOnTaskExecute()
    aObject = GameObject:Get();
    aObject.Params.timerTask = -1;
    CPP_SetAnimState("working");
    CPP_PlaySound("cheese_boil",1);
    local aTrigger = aObject.Triggers.SwitchOn;
    if (aTrigger.cur_value < 0) then
        aTrigger.cur_value = 0;
    end
    aObject.curPortion = aObject.curPortion + 1;
    return 0;
end

function TakePortion()
    aObject = GameObject:Get();
    if (aObject.curObj > 0) then
        aObject.curObj = aObject.curObj - 1;
        if (aObject.curObj <= 0) then
            CPP_RunStringChild("cheese","MakeCheese(0,0);");
        else
            CPP_RunStringChild("cheese","MakeCheese(2,"..aObject.curObj..");");
        end
    end
    return 0;
end

function SwitchOnTrigger()
    aObject = GameObject:Get();
    local aTrigger = aObject.Triggers.SwitchOn;
    if (aTrigger.cur_value < 0) then return; end
    if (aTrigger.cur_value >= aTrigger.work_time) then return; end
    
    local tTask = aTrigger.work_time - aTrigger.cur_value - 1;
    --ScriptDump("time_"..tTask);
    CPP_SetAnimState("time_"..tTask);
    
    aTrigger.cur_value = aTrigger.cur_value + 1;
    if (aTrigger.cur_value >= aTrigger.work_time) then
        --, 
        aObject.curObj = aObject.curObj + 1;
        CPP_SetAnimState("normal");
        if (aObject.curObj <= 0) then
            CPP_RunStringChild("cheese","MakeCheese(0,0);");
        else
            CPP_RunStringChild("cheese","MakeCheese(1,"..aObject.curObj..");");
        end
        aObject.curPortion = aObject.curPortion - 1;
        if (aObject.curPortion > 0) then
            CPP_SetAnimState("working");
            CPP_PlaySound("cheese_boil",1);
            CPP_SetAnimState("time_0");
            aTrigger.cur_value = 0;
        else
            CPP_StopSound("cheese_boil");
            CPP_PlaySound("cheese_completed",0);
            aObject.curPortion = 0;
            aTrigger.cur_value = -1;
        end
    end
end 

--  1     
function CanSleepEnd()
    aObject = GameObject:Get();
    local res = 1;
    --     
    if (aObject.curPortion > 0) then res = 0; end
    --    
    if (aObject.curObj > 0) then res = 0; end
    return res;
end
